/*
 * File    : ETT_PCF8574.H
 * Author  : ETT CO.,LTD 
 *         : Modify From https://github.com/RobTillaart/Arduino/tree/master/libraries/PCF8574
 * Update  : October 2018        
 * Purpose : Library PCF8574/A For I2C Interface Arduino
 * Support : ESP32
 *         : ESP8266
 *         : MEGA32U4
 */
 
//=================================================================================
#ifndef ETT_PCA9548_H
#define ETT_PCA9548_H
//=================================================================================
#if defined(ARDUINO) && ARDUINO >= 100
#include "Arduino.h"
#else
#include "WProgram.h"
#endif
//=================================================================================
#define PCA9548_OK            0x00
#define PCA9548_BUS_ERROR     0x81
#define PCA9548_I2C_ERROR     0x82
//=================================================================================

//=================================================================================
#define PCA9548_ID_DEV0       (0x70)                                             // PCA9548  = 1110,000+(0:W,1:R)
#define PCA9548_ID_DEV1       (0x71)                                             // PCA9548  = 1110,001+(0:W,1:R)
#define PCA9548_ID_DEV2       (0x72)                                             // PCA9548  = 1110,010+(0:W,1:R)
#define PCA9548_ID_DEV3       (0x73)                                             // PCA9548  = 1110,011+(0:W,1:R)
#define PCA9548_ID_DEV4       (0x74)                                             // PCA9548  = 1110,100+(0:W,1:R)
#define PCA9548_ID_DEV5       (0x75)                                             // PCA9548  = 1110,101+(0:W,1:R)
#define PCA9548_ID_DEV6       (0x76)                                             // PCA9548  = 1110,110+(0:W,1:R)
#define PCA9548_ID_DEV7       (0x77)                                             // PCA9548  = 1110,111+(0:W,1:R)
//=================================================================================

//=================================================================================
class ETT_PCA9548
{
public:
  explicit ETT_PCA9548(const uint8_t deviceAddress);          // I2C Assress
  
  void begin(uint8_t val = 0x00);                             // Begin with Bus Select State
  void enableBus();                                           // Enable Bus(0)
  void enableBus(uint8_t bus);                                // Enable Bus(0..7)
  void disableBus();                                          // Disable Bus(All)
  void disableBus(uint8_t bus);                               // Disable Bus(0..7)
  uint8_t readBus();                                          // Read Bus(?)
  uint8_t valueBus() const { return _dataOut; }               // Get Last Bus State
  int lastError();                                            // Get Last Error State
  
private:
  uint8_t _address;
  uint8_t _dataIn;
  uint8_t _dataOut; 
  int     _error;
};
//=================================================================================

//=================================================================================
#endif
//=================================================================================
// END OF FILE
//=================================================================================
